(function($) {

	"use strict";

	var timelineBlocks = $('.cd-timeline-block'),

		offset = 0.8;

	hideBlocks(timelineBlocks, offset);

	$(window).on('scroll', function(){

		(!window.requestAnimationFrame) 

			? setTimeout(function(){ showBlocks(timelineBlocks, offset); }, 100)

			: window.requestAnimationFrame(function(){ showBlocks(timelineBlocks, offset); });

	});

	function hideBlocks(blocks, offset) {

		blocks.each(function(){

			( $(this).offset().top > $(window).scrollTop()+$(window).height()*offset ) && $(this).find('.cd-timeline-img, .cd-timeline-content').addClass('is-hidden');

		});

	}

	function showBlocks(blocks, offset) {

		blocks.each(function(){

			( $(this).offset().top <= $(window).scrollTop()+$(window).height()*offset && $(this).find('.cd-timeline-img').hasClass('is-hidden') ) && $(this).find('.cd-timeline-img, .cd-timeline-content').removeClass('is-hidden').addClass('bounce-in');

		});

	}

})(jQuery);