<?php
ini_set('memory_limit', '2048M');
ini_set('max_execution_time', '0'); // for infinite time of execution
error_reporting(E_ALL ^ E_WARNING);

// Include database connection
include "Admin/config.php";

// Check if gallery ID is provided
if (isset($_GET['id'])) {
    $pro_result = $conn->query('SELECT * FROM gallery WHERE gallery_id = "' . $_GET['id'] . '"');
    $pro_row = mysqli_fetch_array($pro_result);
    $gal_name = $pro_row["gallery_name"];
    $gal_id = $pro_row["gallery_id"];
} else {
    // If no ID provided, redirect or show error
    $pro_result = null;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Creative Moments Studio</title>
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="keywords" content="">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <link
        href="https://fonts.googleapis.com/css?family=Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900,900i"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Adamina" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Libre+Baskerville:400,400i,700&amp;display=swap"
        rel="stylesheet">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/jquery-ui.css">
    <link rel="stylesheet" href="assets/css/font-awesome.min.css">
    <link rel="stylesheet" href="assets/css/flaticon/flaticon.css">
    <link rel="stylesheet" href="assets/css/owl.carousel.min.css">
    <link rel="stylesheet" href="assets/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="assets/css/jquery.fancybox.min.css">
    <link rel="stylesheet" href="assets/css/slicknav.min.css">
    <link rel="stylesheet" href="assets/css/nav-menu.css">
    <link rel="stylesheet" href="assets/css/vmm.menu.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/css/ripple.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="shortcut icon" type="image/png" href="assets/img/favicon.png">

    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>

<body onload="DrawCaptcha();">
    <div id="preloader"></div>

    <?php include "header.php"; ?>

    <section class="innerpage-titlev3">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="ipt-text">
                        <h3>We work for click memories!</h3>
                    </div>
                </div>
            </div>
        </div>
    </section>



    <section class="portfolio-area bgDark section-padding">
        <div class="container">
            <?php if (isset($pro_result) && $pro_result->num_rows == 1) { ?>
                <div class="shuffle-wrapper">
                    <div class="fotolia-grid-2" data-groups='["design"]'>
                        <?php
                        $images = $pro_row['images'];
                        $array = explode('|', $images);
                        foreach ($array as $item) {
                            if ($item != "") {
                        ?>
                                <div class="grid2-item" data-groups='["photography"]'>
                                    <a href="assets/images/portfolio/detail/<?php echo $item; ?>" data-fancybox="gallery">
                                        <img src="assets/images/portfolio/detail/<?php echo $item; ?>" alt="Portfolio Image">
                                    </a>
                                </div>
                        <?php
                            }
                        }
                        ?>
                        <div class="grid2-sizer"></div>
                    </div>
                </div>
            <?php } else { ?>
                <div class="text-center">
                    <h1><i style="font-size:80px;" class="fa fa-smile"></i></h1>
                    <h1>No photos in this album</h1>
                </div>
            <?php } ?>
        </div>
    </section>

    <!--CTA Section-->
    <?php include "cta.php"; ?>
    <?php include "insta-feed.php"; ?>
    <?php include "footer.php"; ?>

    <script src="assets/js/jquery-3.2.0.min.js"></script>
    <script src="assets/js/jquery-ui.js"></script>
    <script src="assets/js/owl.carousel.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/countdown.js"></script>
    <script src="assets/js/jquery.scrollUp.js"></script>
    <script src="assets/js/jquery.waypoints.min.js"></script>
    <script src="assets/js/shuffle.min.js"></script>
    <script src="assets/js/jquery.fancybox.min.js"></script>
    <script src="assets/js/jquery.ripples.min.js"></script>
    <script src="assets/js/jquery.slicknav.min.js"></script>
    <script src="assets/js/vmm.menu.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/wow.js"></script>
    <script src="assets/js/theme.js"></script>
</body>

</html>